<?php
class SmsFlyC {
	private $baseurl = 'http://sms-fly.com/api/api.php';
	private $login;
	private $password;
	private $source;

	public function __construct( $login, $password, $source = "InfoCentr" ) {
		$this->login    = $login;
		$this->password = $password;
		if ( $source == "" ) {
			$this->source = "InfoCentr";
		} else {
			$this->source = htmlspecialchars( $source );
		}

	}

	public function Debug( $var, $exit = true ) {
		echo "<pre>";
		var_dump( $var );
		if ( $exit ) {
			exit();
		}
	}

	public function SendSms( $settings, $debugmode = false ) {
		$source      = $this->source;
		$recipient   = preg_replace( "/[^0-9+]/", '', $settings['SMSFLY_PHONE'] );
		$text        = htmlspecialchars( $settings['SMSFLY_TEXT'] );
		$start_time  = 'AUTO';
		$end_time    = 'AUTO';
		$rate        = 1;
		$lifetime    = 4;
		$description = '';
		$version     = 'tiger 1.0.0';
		$textQuery   = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
		$textQuery   .= "<request>";
		$textQuery   .= "<operation>SENDSMS</operation>";
		$textQuery   .= '		<message start_time="' . $start_time . '" end_time="' . $end_time . '" lifetime="' . $lifetime . '" rate="' . $rate . '" desc="' . $description . '" source="' . $source . '" version="' . $version . '">' . "\n";
		$textQuery   .= "		<body>" . $text . "</body>";
		$textQuery   .= "		<recipient>" . $recipient . "</recipient>";
		$textQuery   .= "</message>";
		$textQuery   .= "</request>";

		$obj = $this->Query( $textQuery );

		if ( $debugmode ) {
			$this->Debug( $obj );
		}

		return $obj;
	}

	public function getInfo($id) {
		$textQuery   = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
		$textQuery   .= "<request>";
		$textQuery   .= "<operation>GETCAMPAIGNDETAIL</operation>";
		$textQuery   .= '<message campaignID="'.$id.'" />';
		$textQuery   .= "</request>";

		$response = $this->Query( $textQuery);

		return $response;
	}

	public function Balance() {
		$textQuery = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
		$textQuery .= "<request>";
		$textQuery .= "<operation>GETBALANCE</operation>";
		$textQuery .= "</request>";

		$obj = $this->Query( $textQuery );

		return $obj;
	}

	private function Query( $textQuery ) {
		$auth = $this->login . ':' . $this->password;
		$ch   = curl_init();
		curl_setopt( $ch, CURLOPT_USERPWD, $auth );
		curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
		curl_setopt( $ch, CURLOPT_POST, 1 );
		curl_setopt( $ch, CURLOPT_URL, $this->baseurl );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array( "Content-Type: text/xml", "Accept: text/xml" ) );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $textQuery );
		$result = curl_exec( $ch );
		curl_close( $ch );

		if ( isset( $result ) ) {
			return $result;
		}

		return false;
	}

	//ERRPHONES  "Неправильный номер получателя!"
	//ACCEPT "Сообщение отправлено."
	//ERRTEXT "Текст сообщения не может быть пустым."
	//ERRALFANAME "Неправильное альфаимя."

	function xmlToArray( $xml ) {
		$response['error'] = 1;

		if ( (string) $xml == 'EMPTY REQUEST' || $xml == false ) {
			$response['error_text'] = "Нет авторизации";
			return $response;
		}

		if ( (string) $xml == 'Access denied!' ) {
			$response['error_text'] = "Не правильный логин или пароль";
			return $response;
		}

		$sxe = new SimpleXMLElement($xml);

		foreach ($sxe as $nameElement => $element) {
			//Вносим текстовый параметр если есть
			$stringparam = trim((string)$element);
			if (!empty($stringparam)) $response[$nameElement]['string'] = (string)$element;

			//получаем аттрибуты
			foreach ($element->attributes() as $nameAttribut => $attribut) {
				$response[$nameElement][$nameAttribut] = (string)$attribut;
			}

			//Обрабатываем элементы нижнего уровня
			$counter = 0;
			foreach ($element as $nameChildren => $children) {
				foreach ($children->attributes() as $nameChildAttribut => $childAttribut) {
					$response[$nameElement][$nameChildren][$counter][$nameChildAttribut] = (string)$childAttribut;
				}
				$counter++;
			}
		}

		$response['error'] = 0;
		$response['error_text'] = '';

		return $response;
	}

}