<?php

IncludeModuleLangFile(__FILE__);

use Bitrix\Main\Loader;
if(class_exists('Bitrix\Main\Loader')) {
	Loader::includeModule("sale");
} else {
	CModule::IncludeModule('sale');
}

global $DB;
$db_type = strtolower($DB->type);
CModule::AddAutoloadClasses(
	"smsfly.module",
	array(
		"CSMSFLYRubric" => "classes/general/rubric.php",
		"CSMSFLYSubscription" => "classes/".$db_type."/subscription.php",
		"CSMSFLYPosting" => "classes/".$db_type."/posting.php",
		"CSMSFLYPostingTemplate" => "classes/general/template.php",
		"CSMSFLYMailTools" => "classes/general/posting.php"
	)
);


require_once dirname(__FILE__).'/classes/smsfly/Sender.php';

Class CSMSFLY_MODULE
{
	function OnBeforeUserRegisterHandler(&$arFields)
	{
		$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
		if(strlen($userField)>0 && $userField !='OFF') $arFields[$userField] = $arFields['PASSWORD'];
	}
	function OnBeforeUserSimpleRegisterHandler(&$arFields)
	{
		$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
		if(strlen($userField)>0 && $userField !='OFF') $arFields[$userField] = $arFields['PASSWORD'];
	}
	function OnBeforeUserUpdateHandler(&$arFields)
	{
		$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
		if(strlen($userField)>0 && $userField !='OFF' && isset($arFields['PASSWORD']) && strlen($arFields['PASSWORD']) >0 ) $arFields[$userField] = $arFields['PASSWORD'];
	}
	function OnBeforeUserAddHandler(&$arFields)
	{
		$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
		if(strlen($userField)>0 && $userField !='OFF' && isset($arFields['PASSWORD']) && strlen($arFields['PASSWORD']) >0 ) $arFields[$userField] = $arFields['PASSWORD'];
	}
	function GetTrackingNumber($my_order_id,$fieldShow = "TRACKING_NUMBER") {
		$my_order_id = intval($my_order_id);
		if($my_order_id <= 0) return '';
		
		if($info = CModule::CreateModuleObject('sale')){
			$testVersion = '1.0.1';
			if(CheckVersion($testVersion, $info->MODULE_VERSION)){
				return '';
			}
			else{
				
			}
		}
		
		$order = \Bitrix\Sale\Order::load($my_order_id);
		
		$shipmentCollection = $order->getShipmentCollection();
		$tmp = '';
		
		$arFields = array();
		foreach ($shipmentCollection as $shipment)
		{
			$tmp= $shipment->getField($fieldShow);
			$id = $shipment->getField("ID");
			$arFields[$id] = $tmp;
			
		}
		ksort($arFields);
		$field = array_pop($arFields);
		
		return $field;
	}
	//����� ���������� ������
	function OnSaleComponentOrderOneStepCompleteHandler($id,$arFields)
	{
		$code = COption::GetOptionString('smsfly.module', 'property_phone');
		
		$switch ='';// COption::GetOptionString('smsfly.module', 'gate');
		if(strlen(trim($code))>0 && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $arFields['ID']);
			
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			

			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;

			$add_phone = COption::GetOptionString('smsfly.module', 'add_phone_new'.SITE_ID);
			$message = COption::GetOptionString('smsfly.module', 'new_order'.SITE_ID);
			$message2 = COption::GetOptionString('smsfly.module', 'new_order_2'.SITE_ID);
		
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}

			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			if(isset($arFields['LID']) && strlen($arFields['LID']) > 0) {
				$sms->Send($phone,$message,array('SITE_ID' => $arFields['LID']));
				$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2,array('SITE_ID' => $arFields['LID'])); };
			} else {
				$sms->Send($phone,$message);
				$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2); };
			}
			
		}
		//call
		$code = COption::GetOptionString('smsfly.module', 'call_property_phone');
		
		$switch = COption::GetOptionString('smsfly.module', 'call_gate');
		if(strlen(trim($code))>0 && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $arFields['ID']);
			
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;

			$add_phone = COption::GetOptionString('smsfly.module', 'call_add_phone_new'.SITE_ID);
			$message = COption::GetOptionString('smsfly.module', 'call_new_order'.SITE_ID);
			$message2 = COption::GetOptionString('smsfly.module', 'call_new_order_2'.SITE_ID);
		
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field2');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}

			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			$sms->SendCall($phone,$message);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->SendCall(trim($addPhone),$message2); };
		}
		
	}
	function OnSaleComponentOrderCompleteHandler($id,$arFields)
	{
		$code = COption::GetOptionString('smsfly.module', 'property_phone');
		$switch ='';// COption::GetOptionString('smsfly.module', 'gate');
		
		if(strlen(trim($code))>0 && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $arFields['ID']);
			
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'add_phone_new'.SITE_ID);
			$message = COption::GetOptionString('smsfly.module', 'new_order'.SITE_ID);
			$message2 = COption::GetOptionString('smsfly.module', 'new_order_2'.SITE_ID);
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			if(isset($arFields['LID']) && strlen($arFields['LID']) > 0) {
				$sms->Send($phone,$message,array('SITE_ID' => $arFields['LID']));
				$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2,array('SITE_ID' => $arFields['LID'])); };
			} else {
				$sms->Send($phone,$message);
				$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2); };
			}
			//$sms->Send($phone,$message);
			//$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2); };
		}
		
		
		$code = COption::GetOptionString('smsfly.module', 'call_property_phone');
		$switch = COption::GetOptionString('smsfly.module', 'call_gate');
		
		if(strlen(trim($code))>0 && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $arFields['ID']);
			
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'call_add_phone_new'.SITE_ID);
			$message = COption::GetOptionString('smsfly.module', 'call_new_order'.SITE_ID);
			$message2 = COption::GetOptionString('smsfly.module', 'call_new_order_2'.SITE_ID);
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field2');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			$sms->SendCall($phone,$message);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->SendCall(trim($addPhone),$message2); };
		}
	}
	//����� ������ ������
	function OnSalePayOrderHandler($id,$val)
	{
		if(isset($GLOBALS['CSMSFLY_MODULE']['OnSalePayOrderHandler'][$id]))
			return;
		$GLOBALS['CSMSFLY_MODULE']['OnSalePayOrderHandler'][$id] = '';
		
		$code = COption::GetOptionString('smsfly.module', 'property_phone');
		$switch ='';// COption::GetOptionString('smsfly.module', 'gate');

		if(strlen(trim($code))>0 && $val == 'Y' && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $id);
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}

			$arFields = CSaleOrder::GetByID($id);
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'add_phone_pay'.$arFields['LID']);
			$message = COption::GetOptionString('smsfly.module', 'on_pay_order'.$arFields['LID']);
			$message2 = COption::GetOptionString('smsfly.module', 'on_pay_order_2'.$arFields['LID']);
			
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);

			$sms = new CSMSFLY;
			$arParams['SITE_ID'] = $arFields['LID'];
			$sms->Send($phone,$message,$arParams);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2); };
		}

		//call

		$code = COption::GetOptionString('smsfly.module', 'call_property_phone');
		$switch = COption::GetOptionString('smsfly.module', 'call_gate');

		if(strlen(trim($code))>0 && $val == 'Y' && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $id);
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}

			$arFields = CSaleOrder::GetByID($id);

			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);

			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);

			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;

			$add_phone = COption::GetOptionString('smsfly.module', 'call_add_phone_pay'.$arFields['LID']);
			$message = COption::GetOptionString('smsfly.module', 'call_on_pay_order'.$arFields['LID']);
			$message2 = COption::GetOptionString('smsfly.module', 'call_on_pay_order_2'.$arFields['LID']);


			$userField = COption::GetOptionString('smsfly.module', 'user_password_field2');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}

			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);

			$sms = new CSMSFLY;
			$arParams['SITE_ID'] = $arFields['LID'];
			$sms->SendCall($phone,$message,$arParams);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->SendCall(trim($addPhone),$message2); };
		}

	}
	//����� ���������� �� ��������
	function OnSaleDeliveryOrderHandler($id,$val)
	{
		if(isset($GLOBALS['CSMSFLY_MODULE']['OnSaleDeliveryOrderHandler'][$id]))
			return;
		$GLOBALS['CSMSFLY_MODULE']['OnSaleDeliveryOrderHandler'][$id] = '';
		
		$code = COption::GetOptionString('smsfly.module', 'property_phone');
		$switch ='';// COption::GetOptionString('smsfly.module', 'gate');
		
		if(strlen(trim($code))>0 && $val == 'Y' && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $id);
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}

			$arFields = CSaleOrder::GetByID($id);
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'add_phone_delivery'.$arFields['LID']);
			$message2 = COption::GetOptionString('smsfly.module', 'order_delivery_2'.$arFields['LID']);
			$message = COption::GetOptionString('smsfly.module', 'order_delivery'.$arFields['LID']);
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
			
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			$arParams['SITE_ID'] = $arFields['LID'];
			$sms->Send($phone,$message,$arParams);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2); };
		}
		
		#call
		
		$code = COption::GetOptionString('smsfly.module', 'call_property_phone');
		$switch = COption::GetOptionString('smsfly.module', 'call_gate');
		
		if(strlen(trim($code))>0 && $val == 'Y' && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $id);
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}

			$arFields = CSaleOrder::GetByID($id);
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'call_add_phone_delivery'.$arFields['LID']);
			$message2 = COption::GetOptionString('smsfly.module', 'call_order_delivery_2'.$arFields['LID']);
			$message = COption::GetOptionString('smsfly.module', 'call_order_delivery'.$arFields['LID']);
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field2');
			
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			$arParams['SITE_ID'] = $arFields['LID'];
			$sms->SendCall($phone,$message,$arParams);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->SendCall(trim($addPhone),$message2); };
		}
	}
	//����� ������ ������
	function OnSaleCancelOrderHandler($id,$val)
	{
		if(isset($GLOBALS['CSMSFLY_MODULE']['OnSaleCancelOrderHandler'][$id]))
			return;
		$GLOBALS['CSMSFLY_MODULE']['OnSaleCancelOrderHandler'][$id] = '';
		
		$code = COption::GetOptionString('smsfly.module', 'property_phone');
		$switch ='';// COption::GetOptionString('smsfly.module', 'gate');

		if(strlen(trim($code))>0 && $val == 'Y' && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $id);
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}

			$arFields = CSaleOrder::GetByID($id);
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'add_phone_cancel'.$arFields['LID']);
			$message = COption::GetOptionString('smsfly.module', 'order_cancel'.$arFields['LID']);
			$message2 = COption::GetOptionString('smsfly.module', 'order_cancel_2'.$arFields['LID']);
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			$arParams['SITE_ID'] = $arFields['LID'];
			$sms->Send($phone,$message,$arParams);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2); };
		}
		#call
		$code = COption::GetOptionString('smsfly.module', 'call_property_phone');
		$switch = COption::GetOptionString('smsfly.module', 'call_gate');

		if(strlen(trim($code))>0 && $val == 'Y' && $switch != 'OFF') {
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $id);
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}

			$arFields = CSaleOrder::GetByID($id);
			
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$arFields['STATUS_ID'],'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'call_add_phone_cancel'.$arFields['LID']);
			$message = COption::GetOptionString('smsfly.module', 'call_order_cancel'.$arFields['LID']);
			$message2 = COption::GetOptionString('smsfly.module', 'call_order_cancel_2'.$arFields['LID']);
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field2');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			$arParams['SITE_ID'] = $arFields['LID'];
			$sms->SendCall($phone,$message,$arParams);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->SendCall(trim($addPhone),$message2); };
		}
		
	}
	
	//����� ����� ������� ������
	function OnSaleStatusOrderHandler($id,$val)
	{
		if(isset($GLOBALS['CSMSFLY_MODULE']['OnSaleStatusOrderHandler'][$id]))
			return;
		$GLOBALS['CSMSFLY_MODULE']['OnSaleStatusOrderHandler'][$id] = '';
		
		$code = COption::GetOptionString('smsfly.module', 'property_phone');
		$switch ='';// COption::GetOptionString('smsfly.module', 'gate');
		if(strlen(trim($code))>0 && $switch != 'OFF') {
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$val,'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $id);
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}

			$arFields = CSaleOrder::GetByID($id);
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'add_phone_status_'.$val.$arFields['LID']);
			$message = COption::GetOptionString('smsfly.module', 'status_'.$val.$arFields['LID']);
			$message2 = COption::GetOptionString('smsfly.module', 'status_'.$val.'_2'.$arFields['LID']);
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			$arParams['SITE_ID'] = $arFields['LID'];
			$sms->Send($phone,$message,$arParams);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->Send(trim($addPhone),$message2); };
		}
		
		#call
		
		$code = COption::GetOptionString('smsfly.module', 'call_property_phone');
		$switch = COption::GetOptionString('smsfly.module', 'call_gate');
		if(strlen(trim($code))>0 && $switch != 'OFF') {
			$obStatus = CSaleStatus::GetList(array(),array('ID'=>$val,'LID'=>LANGUAGE_ID));
			$status = '';
			if($arStat = $obStatus->Fetch()) $status = $arStat['NAME'];
			
			$db_props = CSaleOrderProps::GetList(array("SORT" => "ASC"),array("TYPE" => array('TEXT','TEXTAREA','STRING','NUMBER')));
			$arReplaces = array();
			while($arProps = $db_props->Fetch()) {if(!in_array($arProps['CODE'],$arReplaces) && strlen($arProps['CODE'])>0) $arReplaces['#PROP_'.$arProps['CODE'].'#'] = $arProps['CODE'];}
			$arFilter = array("ORDER_ID" 	=> $id);
			$db_order = CSaleOrderPropsValue::GetList(array(),$arFilter);
			$phone = '';
			while($arOrder = $db_order->Fetch()) {
				if($arOrder['CODE'] == $code) $phone = $arOrder['VALUE'];
				if(in_array($arOrder['CODE'],$arReplaces)) $arReplaces['#PROP_'.$arOrder['CODE'].'#'] = $arOrder['VALUE'];
			}

			$arFields = CSaleOrder::GetByID($id);
			$delivery = CSaleDelivery::GetByID($arFields['DELIVERY_ID']);
			
			
			
			$arReplacesTemlate = array(
				'#ACCOUNT_NUMBER#'	=> ($arFields['ACCOUNT_NUMBER'])?$arFields['ACCOUNT_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'ACCOUNT_NUMBER'),
				'#ORDER_NUMBER#' 	=> $arFields['ID'],
				'#ORDER_SUMM#'		=> ($arFields['PRICE']-$arFields['PRICE_DELIVERY']),
				'#PRICE_DELIVERY#'	=> $arFields['PRICE_DELIVERY'],
				'#PRICE#'		=> $arFields['PRICE'],
				'#DELIVERY_DOC_NUM#'	=> ($arFields['DELIVERY_DOC_NUM'])?$arFields['DELIVERY_DOC_NUM']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_NUM'),
				'#DELIVERY_DOC_DATE#'	=> ($arFields['DELIVERY_DOC_DATE'])?$arFields['DELIVERY_DOC_DATE']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_DOC_DATE'),
				'#STATUS_NAME#'		=> $status,
				'#DELIVERY_NAME#'	=> !empty($delivery['NAME'])?$delivery['NAME']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'],'DELIVERY_NAME'),
				'#TRACKING_NUMBER#'	=> ($arFields['TRACKING_NUMBER'])?$arFields['TRACKING_NUMBER']:CSMSFLY_MODULE::GetTrackingNumber($arFields['ID'])
			);
			//foreach($arReplacesTemlate as $codeTMP => $valTMP) {
			//	
			//}
			
			foreach($arFields as $k => $v)
				if(!isset($arReplacesTemlate['#'.$k.'#'])) $arReplacesTemlate['#'.$k.'#'] = $v;
			
			$add_phone = COption::GetOptionString('smsfly.module', 'call_add_phone_status_'.$val.$arFields['LID']);
			$message = COption::GetOptionString('smsfly.module', 'call_status_'.$val.$arFields['LID']);
			$message2 = COption::GetOptionString('smsfly.module', 'call_status_'.$val.'_2'.$arFields['LID']);
			
			$userField = COption::GetOptionString('smsfly.module', 'user_password_field2');
			if(strlen($userField)>0 && $userField !='OFF') {
				$rsUser = CUser::GetByID($arFields['USER_ID']);
				$arUser = $rsUser->Fetch();
				$arUser['PASSWORD'] = (strlen(trim($arUser[$userField]))>0)?$arUser[$userField]:'';
				$arUserF = array();
				foreach($arUser as $id => $value) {
					$arUserF['#'.$id.'#'] = $value;
				}
				
				$message = str_replace(array_keys($arUserF),$arUserF,$message);
				$message2 = str_replace(array_keys($arUserF),$arUserF,$message2);
			}
			
			$message = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message);
			$message2 = str_replace(array_keys($arReplacesTemlate),$arReplacesTemlate,$message2);
			$message = str_replace(array_keys($arReplaces),$arReplaces,$message);
			$message2 = str_replace(array_keys($arReplaces),$arReplaces,$message2);
			
			$sms = new CSMSFLY;
			$arParams['SITE_ID'] = $arFields['LID'];
			$sms->SendCall($phone,$message,$arParams);
			$arAddPhone = explode(',',$add_phone); foreach($arAddPhone as $addPhone) { $sms->SendCall(trim($addPhone),$message2); };
		}
	}
	function OnBuildGlobalMenu() {
		
	}
	
	
	// ����������� ���� D7
	
	// ���� ������������ ������ ���� ��������
	function OnSaleOrderPaidHandler($ENTITY)
	{
		$parameters = $ENTITY->getParameters();
		
		/** @var Sale\Order $order */
		$order = $parameters['ENTITY'];
		$ID = $order->getField('ID');
		$value = $order->getField('PAYED');
		
		self::OnSalePayOrderHandler($ID, $value);
	}
	
	// ���� ��� ������� ���� ���������� ��������
	function OnShipmentAllowDeliveryHandler($ENTITY)
	{
		$parameters = $ENTITY->getParameters();

		/** @var Sale\Shipment $shipment */
		$shipment = $parameters['ENTITY'];
		$oldValues = $parameters['VALUES'];
		$allow_delivery = $shipment->getField('ALLOW_DELIVERY');
		$ORDER_ID = $shipment->getField('ORDER_ID');
		$ID = $shipment->getField('ID');
		
		self::OnSaleDeliveryOrderHandler($ORDER_ID, $allow_delivery);
	}
	
	// ���� ����������� ����� ��� �������
	function OnSaleOrderCanceledHandler($ENTITY)
	{
		$order = $ENTITY->getParameter('ENTITY');
		$ID = $order->getField('ID');
		$canceled = $order->getField('CANCELED');
		
		self::OnSaleCancelOrderHandler($ID, $canceled);
	}
	
	// ���� ������ ������ ��� �������
	function OnSaleStatusOrderChangeHandler($ENTITY)
	{
		$value = $ENTITY->getParameter('VALUE');
		$order = $ENTITY->getParameter('ENTITY');
		$ID = $order->getField('ID');
		
		self::OnSaleStatusOrderHandler($ID, $value);
	}
}
?>